package objectos_casa;

import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;


/**
 * Created by Pedro on 06/04/2016.
 */
public class Array_double extends ObjectoCasa{
    public String nome;
    public ArrayList<Double> lista;
    public int tamanho;

    public Array_double(String identificador, int numero_id){
        path_icone = "array_double.bmp";
        id=numero_id;
        nome=identificador;
        lista= new ArrayList(1);
        lista.add(0.0);
        tamanho=lista.size();
    }


    public Array_double(String indentificador, int numero_id, int size){
        path_icone = "/objectos_casa/imagens/array_double.bmp";
        if(size<0) {
            System.err.println("Tamanho do array é negativo! O protótipo irá criar um array com tamanho 1.");
            size=1;
        }
        id=numero_id;
        nome=indentificador;
        lista=new ArrayList(size);
        int temp=size;

        do{
            lista.add(0.0);
            temp--;
        }
        while(temp>0);
        tamanho=size;
    }


    public void addElem(){
        lista.add(0.0);
        tamanho++;
    }


    public void addElem(double d){
        lista.add(d);
        tamanho++;
    }

    public double getElem(int pos){
        return lista.get(pos);
    }

    public void removeElem(int pos){
        lista.remove(pos);
        tamanho--;
    }

    public void setElem(double d, int pos){
        try {
            lista.set(pos, d);
        }
        catch (IndexOutOfBoundsException e){
            System.err.println("Indice de array inválido!"+'\n'+e.getMessage());
        }
    }

    public void printLista(){
        for( int i=0;i<tamanho;i++)
            System.out.println("Posição "+i+":"+lista.get(i));

    }

    public String gerar(){

        return nome+"="+lista.toString()+'\n';
    }

    @Override
    public String tipo_objecto(){return "array_double";}


    public String to_expressao() {
        return nome;
    }

}
